IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Tag') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Tag
END
GO

CREATE PROCEDURE [dbo].[CPJ_Tag] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

DECLARE  @pTabla		VARCHAR(100)
		,@pId_Usuario	INT
		,@pId			VARCHAR(100)
		,@pMarcar		TINYINT
		,@pFlag_Todos	TINYINT


SET @pTabla				= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tabla')), 0)
SET @pId_Usuario		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pId				= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id')), 0)
SET @pMarcar			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Marcar')), 0)
SET @pFlag_Todos		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Todos')), 0)


IF RTRIM(LTRIM(@pTabla)) = '' RETURN 1
IF RTRIM(LTRIM(@pId)) = '' AND @pFlag_Todos = 0 RETURN 1
IF @pId_Usuario = 0 RETURN 1

DECLARE @equate INT


IF UPPER(@pTabla) = 'PROD_FAMILIAS'
BEGIN
	SET @equate = 80
	IF @pMarcar = 0
	BEGIN	
	    IF @pFlag_Todos = 1
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
		ELSE					
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate AND Ptr = @pId
	END
    ELSE
	BEGIN
	    IF @pFlag_Todos = 1
		BEGIN
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
			INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) 
			SELECT @pId_Usuario,@equate,Id_Familia,CONVERT(CHAR(10),Id_Familia) FROM Prod_Familias
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM TagFile_ TAG WHERE TAG.Usr = @pId_Usuario AND TAG.Tbl = @equate AND TAG.Ptr = @pId) 
				INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) VALUES (@pId_Usuario,@equate,CONVERT(INT,@pId),CONVERT(CHAR(10),@pId))
		END
		
	END

END 

IF UPPER(@pTabla) = 'CBTES'
BEGIN
	SET @equate = 300
	IF @pMarcar = 0
	BEGIN	
	    IF @pFlag_Todos = 1
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
		ELSE					
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate AND Ptr = @pId
	END
    ELSE
	BEGIN
	    IF @pFlag_Todos = 1
		BEGIN
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
			INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) 
			SELECT @pId_Usuario,@equate,Id_Trans,CONVERT(CHAR(10),Id_Trans) FROM Cbtes
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM TagFile_ TAG WHERE TAG.Usr = @pId_Usuario AND TAG.Tbl = @equate AND TAG.Ptr = @pId) 
				INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) VALUES (@pId_Usuario,@equate,CONVERT(INT,@pId),CONVERT(CHAR(10),@pId))
		END
		
	END

END 


IF UPPER(@pTabla) = 'PRODUCTOS'
BEGIN
	SET @equate = 90
	IF @pMarcar = 0
	BEGIN	
	
	    IF @pFlag_Todos = 1
			DELETE TagFilePos_ WHERE Usr = @pId_Usuario AND Tbl = @equate
		ELSE					
			DELETE TagFilePos_ WHERE Usr = @pId_Usuario AND Tbl = @equate AND Pos = @pId
	END
    ELSE
	BEGIN
	
	    IF @pFlag_Todos = 1
		BEGIN
		
			DELETE TagFilePos_ WHERE Usr = @pId_Usuario AND Tbl = @equate
			INSERT INTO TagFilePos_ (Usr,Tbl,Pos,Val) 
			SELECT @pId_Usuario,@equate,Id_Trans,CONVERT(CHAR(10),Id_Trans) FROM Cbtes
		END
		ELSE
		BEGIN

			IF NOT EXISTS (SELECT 1 FROM TagFilePos_ TAG WHERE TAG.Usr = @pId_Usuario AND TAG.Tbl = @equate AND TAG.Pos = @pId) 
				INSERT INTO TagFilePos_ (Usr,Tbl,Pos,Val) VALUES (@pId_Usuario,@equate,@pId,CONVERT(VARCHAR(20),@pId))

		END
		
		
	END

END 


IF UPPER(@pTabla) = 'CAJAS_PERIODOS'
BEGIN
	SET @equate = 250
	IF @pMarcar = 0
	BEGIN	
	    IF @pFlag_Todos = 1
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
		ELSE					
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate AND Ptr = @pId
	END
    ELSE
	BEGIN
	    IF @pFlag_Todos = 1
		BEGIN
			DELETE TagFile_ WHERE Usr = @pId_Usuario AND Tbl = @equate
			INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) 
			SELECT @pId_Usuario,@equate,Id_Periodo_Caja,CONVERT(CHAR(10),Id_Periodo_Caja) FROM Cajas_Periodos
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM TagFile_ TAG WHERE TAG.Usr = @pId_Usuario AND TAG.Tbl = @equate AND TAG.Ptr = @pId) 
				INSERT INTO TagFile_ (Usr,Tbl,Ptr,Val) VALUES (@pId_Usuario,@equate,CONVERT(INT,@pId),CONVERT(CHAR(10),@pId))
		END
		
	END

END 




RETURN 0

 


/*

EXEC dbo.CPJ_Tag   '{
			"Id_Usuario":"-1",
			"Tabla":"Prod_Familias",
			"Id":"3",
			"Marcar":"1"
		}'

SELECT * FROM TagFile_ TAG WHERE TAG.Usr = -1 AND TAG.Tbl = 80

EXEC dbo.CPJ_Tag   '{
			"Id_Usuario":"-1",
			"Tabla":"Prod_Familias",
			"Id":"3",
			"Marcar":"0"
		}'

SELECT * FROM TagFile_ TAG WHERE TAG.Usr = -1 AND TAG.Tbl = 80


*/
